#include <p30fxxxx.h>
#include <xlcd.h>

/*External LCD functions are only defined for the following devices */
#if defined(__dsPIC30F5011__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/*******************************************************************
Function Name   :   ReadAddrXLCD
Description     :   This function reads a byte which is a 7 bit 
                    address and the BF forms the eight bit .
                    The user must first check the busy status 
                    of the LCD cntrlr by calling the BusyXLCD()
Input parameters:   none
Return value    :   char address
********************************************************************/

char ReadAddrXLCD(void)
{
    char address;
    char temp[7],i;

    /* Configure all pins as input */
    TRIS_DATA_PIN_7 = 1;
    TRIS_DATA_PIN_6 = 1;
    TRIS_DATA_PIN_5 = 1;
    TRIS_DATA_PIN_4 = 1;
# ifdef EIGHT_BIT_INTERFACE
    TRIS_DATA_PIN_3 = 1;
    TRIS_DATA_PIN_2 = 1;
    TRIS_DATA_PIN_1 = 1;
    TRIS_DATA_PIN_0 = 1;
#endif
    
    RW_PIN = 1;                 /* for read operation */
    RS_PIN = 0;                 /* for selecting AC for read */
    Delay18Tcy();
    E_PIN = 1;                  /* for enabling read/write */
    Delay18Tcy();

    temp[6] = (char) DATA_PIN_6;
    temp[6] = temp[6] << 6;
    temp[5] = (char) DATA_PIN_5;
    temp[5] = temp[5] << 5;
    temp[4] = (char) DATA_PIN_4;
    temp[4] = temp[4] << 4;

#ifdef EIGHT_BIT_INTERFACE
    temp[3] = (char) DATA_PIN_3;
    temp[3] = temp[3] << 3;
    temp[2] = (char) DATA_PIN_2;
    temp[2] = temp[2] << 2;
    temp[1] = (char) DATA_PIN_1;
    temp[1] = temp[1] << 1;
    temp[0] = (char) DATA_PIN_0;
    E_PIN = 0;                  /* disable read/write */
#else
    E_PIN = 0;                  /* disable read/write */

    RW_PIN = 1;                 /* for read operation */
    RS_PIN = 0;                 /* for selecting AC for read */
    E_PIN = 1;                  /* for enabling read/write */
    Delay18Tcy();
    temp[3] = (char) DATA_PIN_7;
    temp[3] = temp[3] << 3;
    temp[2] = (char) DATA_PIN_6;
    temp[2] = temp[2] << 2;
    temp[1] = (char) DATA_PIN_5;
    temp[1] = temp[1] << 1;
    temp[0] = (char) DATA_PIN_4;
    E_PIN = 0;                  /* disable read/write */
#endif
    for (i=0;i<8;i++)
    {
        address |= temp[i];
    }

    return address;
} 

#endif
/* end of file */
